---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/definition"
aliases:
  - Embedding Depth
  - Layer Count
---

# Recursive Depth (n)

> Depth `n` in $R^n(\Delta_0)$ measures how many embedding layers a difference traverses before stabilization is evaluated.

---

## Definition

In Delta Theory, **Recursive Depth** measures relational layering:
- `R(·)` embeds difference into relations
- `R^n` repeats that embedding n times
- n is dimensionless; indexes context, not distance

---

## Dual‑register mapping

### Technical (network/computational)

| Term concept | Network construct | Interface example |
|-------------|------------------|-------------------|
| Depth | Layer count | `StackDepth`, `Level` |
| Cost | Resource use | `Complexity`, `Budget` |
| Signal | Strength decay | `Attenuation`, `Loss` |

### Humane (biological/relational)

| Term concept | Humane construct | Example |
|-------------|------------------|----------|
| Depth | Understanding levels | "How deep it goes" |
| Cost | Energy required | "Takes more effort" |
| Signal | Clarity loss | "Gets harder to see" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Layer | Level | How far embedded |
| Resource | Effort | What it takes |
| Decay | Fading | How strength drops |

### Domain Examples

| Domain | Technical manifestation | Humane manifestation |
|--------|------------------------|---------------------|
| Physics | Field coupling layers | Natural nesting |
| Networks | Protocol stack | Living layers |
| Cognition | Memory hierarchy | Depth of meaning |
| Systems | Nested systems | Organic levels |

---

## Scale Effects

How Recursive Depth manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum layers | Wave functions |
| λV | State hierarchy | Energy levels |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Coherence span | Attention depth |
| ∇S | Layer clarity | Clear levels |

### Universe Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Causal depth | Cosmic structure |
| λV | Layer horizon | Galaxy hierarchy |

Note: At extreme scales, Recursive Depth faces fundamental limits (e.g., quantum uncertainty at ε, causal disconnection at c) that affect how many layers can be stably maintained.

---

## Ontological Role

| Domain | Role |
|--------|------|
| Structure | Enables stratification |
| Void | Adds interface layers |
| Awareness | Tests coherence span |

More depth exposes constraints and interfaces, enabling closure when supported.

---

## Comparisons

Compare with related terms:

| Term | Distinction | Example |
|------|------------|---------|
| Depth | Layer count | Stack levels |
| Interval | Time span | Cycle period |
| Closure | Stability test | Pattern lock |

---

## Recursive Function

Depth appears in embedding iteration:

$$
R^n(\Delta_0) \quad \text{with cost } \propto f(n)
$$

Where:
- n = recursion depth
- f(n) = cost function
- $\Delta_0$ = initial difference

---

## Design rationale

This term must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical stack depth nor experiential understanding levels alone captures its full meaning.

---

## See Also

- [[Relation]]
- [[RelationalEmbedding]]
- [[Stabilization (Closure)]]
- [[Recurrence Interval]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale effects documented